package serializers

// |@@| C

import (
	"encoding/json"
	"gardening/src/lib/to_json"
	"gardening/src/mdl"
	"strings"
)

type EventSerializer struct {
}

func (this *EventSerializer) OneToJson(event *mdl.Event) (json.RawMessage, error) {

	var fields []string
	var field string
	field, _ = to_json.StringField("id", event.Id)
	fields = append(fields, field)
	field, _ = to_json.TimeField("created_at", event.CreatedAt)
	fields = append(fields, field)
	field, _ = to_json.TimeField("updated_at", event.UpdatedAt)
	fields = append(fields, field)
	field, _ = to_json.StringField("what", event.What)
	fields = append(fields, field)
	field, _ = to_json.StringField("who", event.Who)
	fields = append(fields, field)
	field, _ = to_json.TimeField("when", event.When)
	fields = append(fields, field)
	field, _ = to_json.StringField("why", event.Why)
	fields = append(fields, field)
	field, _ = to_json.StringField("resource_id", event.ResourceId)
	fields = append(fields, field)
	field, _ = to_json.StringField("resource_type", event.ResourceType)
	fields = append(fields, field)

	return json.RawMessage("{" + strings.Join(fields, ",") + "}"), nil
}
func (this *EventSerializer) SetToJson(events []*mdl.Event) (json.RawMessage, error) {

	var jsonStrings []string
	for _, event := range events {
		j, err := this.OneToJson(event)
		if err != nil {
			return json.RawMessage(""), err
		}
		jsonStrings = append(jsonStrings, string(j))
	}
	return json.RawMessage("[" + strings.Join(jsonStrings, ",") + "]"), nil
}
