package serializers

// |@@| C

import (
	"encoding/json"
	"gardening/src/lib/to_json"
	"gardening/src/mdl"
	"strings"
)

type GardenSerializer struct {
}

func (this *GardenSerializer) OneToJson(garden *mdl.Garden) (json.RawMessage, error) {

	var fields []string
	var field string
	field, _ = to_json.StringField("id", garden.Id)
	fields = append(fields, field)
	field, _ = to_json.TimeField("created_at", garden.CreatedAt)
	fields = append(fields, field)
	field, _ = to_json.TimeField("updated_at", garden.UpdatedAt)
	fields = append(fields, field)
	field, _ = to_json.StringField("name", garden.Name)
	fields = append(fields, field)
	field, _ = to_json.StringField("picture", garden.Picture)
	fields = append(fields, field)

	return json.RawMessage("{" + strings.Join(fields, ",") + "}"), nil
}
func (this *GardenSerializer) SetToJson(gardens []*mdl.Garden) (json.RawMessage, error) {

	var jsonStrings []string
	for _, garden := range gardens {
		j, err := this.OneToJson(garden)
		if err != nil {
			return json.RawMessage(""), err
		}
		jsonStrings = append(jsonStrings, string(j))
	}
	return json.RawMessage("[" + strings.Join(jsonStrings, ",") + "]"), nil
}
