package serializers

// |@@| C

import (
	"encoding/json"
	"gardening/src/lib/to_json"
	"gardening/src/mdl"
	"strings"
)

type GardenTaskSerializer struct {
}

func (this *GardenTaskSerializer) OneToJson(gardenTask *mdl.GardenTask) (json.RawMessage, error) {

	var fields []string
	var field string
	field, _ = to_json.StringField("id", gardenTask.Id)
	fields = append(fields, field)
	field, _ = to_json.TimeField("created_at", gardenTask.CreatedAt)
	fields = append(fields, field)
	field, _ = to_json.TimeField("updated_at", gardenTask.UpdatedAt)
	fields = append(fields, field)
	field, _ = to_json.StringField("description", gardenTask.Description)
	fields = append(fields, field)
	field, _ = to_json.StringField("name", gardenTask.Name)
	fields = append(fields, field)
	field, _ = to_json.TimeField("start_date", gardenTask.StartDate)
	fields = append(fields, field)
	field, _ = to_json.StringField("garden_id", gardenTask.GardenId)
	fields = append(fields, field)
	field, _ = to_json.StringField("plantation_id", gardenTask.PlantationId)
	fields = append(fields, field)

	return json.RawMessage("{" + strings.Join(fields, ",") + "}"), nil
}
func (this *GardenTaskSerializer) SetToJson(gardenTasks []*mdl.GardenTask) (json.RawMessage, error) {

	var jsonStrings []string
	for _, gardenTask := range gardenTasks {
		j, err := this.OneToJson(gardenTask)
		if err != nil {
			return json.RawMessage(""), err
		}
		jsonStrings = append(jsonStrings, string(j))
	}
	return json.RawMessage("[" + strings.Join(jsonStrings, ",") + "]"), nil
}
