package serializers

// |@@| C

import (
	"encoding/json"
	"gardening/src/lib/to_json"
	"gardening/src/mdl"
	"strings"
)

type PlantSerializer struct {
}

func (this *PlantSerializer) OneToJson(plant *mdl.Plant) (json.RawMessage, error) {

	var fields []string
	var field string
	field, _ = to_json.StringField("id", plant.Id)
	fields = append(fields, field)
	field, _ = to_json.TimeField("created_at", plant.CreatedAt)
	fields = append(fields, field)
	field, _ = to_json.TimeField("updated_at", plant.UpdatedAt)
	fields = append(fields, field)
	field, _ = to_json.JsonField("data", plant.Data)
	fields = append(fields, field)
	field, _ = to_json.StringField("description", plant.Description)
	fields = append(fields, field)
	field, _ = to_json.StringField("exposition", plant.Exposition)
	fields = append(fields, field)
	field, _ = to_json.DecimalField("harvested", plant.Harvested)
	fields = append(fields, field)
	field, _ = to_json.StringField("name", plant.Name)
	fields = append(fields, field)
	field, _ = to_json.BooleanField("perennial", plant.Perennial)
	fields = append(fields, field)
	field, _ = to_json.StructField("planting_schema", plant.PlantingSchema)
	fields = append(fields, field)
	field, _ = to_json.StringField("reference", plant.Reference)
	fields = append(fields, field)
	field, _ = to_json.IntegerField("size", plant.Size)
	fields = append(fields, field)

	return json.RawMessage("{" + strings.Join(fields, ",") + "}"), nil
}
func (this *PlantSerializer) SetToJson(plants []*mdl.Plant) (json.RawMessage, error) {

	var jsonStrings []string
	for _, plant := range plants {
		j, err := this.OneToJson(plant)
		if err != nil {
			return json.RawMessage(""), err
		}
		jsonStrings = append(jsonStrings, string(j))
	}
	return json.RawMessage("[" + strings.Join(jsonStrings, ",") + "]"), nil
}
