package serializers

// |@@| C

import (
	"encoding/json"
	"gardening/src/lib/to_json"
	"gardening/src/mdl"
	"strings"
)

type PlantTaskSerializer struct {
}

func (this *PlantTaskSerializer) OneToJson(plantTask *mdl.PlantTask) (json.RawMessage, error) {

	var fields []string
	var field string
	field, _ = to_json.StringField("id", plantTask.Id)
	fields = append(fields, field)
	field, _ = to_json.TimeField("created_at", plantTask.CreatedAt)
	fields = append(fields, field)
	field, _ = to_json.TimeField("updated_at", plantTask.UpdatedAt)
	fields = append(fields, field)
	field, _ = to_json.StringField("description", plantTask.Description)
	fields = append(fields, field)
	field, _ = to_json.StringField("name", plantTask.Name)
	fields = append(fields, field)
	field, _ = to_json.TimeField("start_date", plantTask.StartDate)
	fields = append(fields, field)
	field, _ = to_json.StringField("plant_id", plantTask.PlantId)
	fields = append(fields, field)

	return json.RawMessage("{" + strings.Join(fields, ",") + "}"), nil
}
func (this *PlantTaskSerializer) SetToJson(plantTasks []*mdl.PlantTask) (json.RawMessage, error) {

	var jsonStrings []string
	for _, plantTask := range plantTasks {
		j, err := this.OneToJson(plantTask)
		if err != nil {
			return json.RawMessage(""), err
		}
		jsonStrings = append(jsonStrings, string(j))
	}
	return json.RawMessage("[" + strings.Join(jsonStrings, ",") + "]"), nil
}
