package serializers

// |@@| C

import (
	"encoding/json"
	"gardening/src/lib/to_json"
	"gardening/src/mdl"
	"strings"
)

type PlantationSerializer struct {
}

func (this *PlantationSerializer) OneToJson(plantation *mdl.Plantation) (json.RawMessage, error) {

	var fields []string
	var field string
	field, _ = to_json.StringField("id", plantation.Id)
	fields = append(fields, field)
	field, _ = to_json.TimeField("created_at", plantation.CreatedAt)
	fields = append(fields, field)
	field, _ = to_json.TimeField("updated_at", plantation.UpdatedAt)
	fields = append(fields, field)
	field, _ = to_json.StringField("name", plantation.Name)
	fields = append(fields, field)
	field, _ = to_json.TimeField("planted_at", plantation.PlantedAt)
	fields = append(fields, field)
	field, _ = to_json.StringField("plant_id", plantation.PlantId)
	fields = append(fields, field)
	field, _ = to_json.StringField("garden_id", plantation.GardenId)
	fields = append(fields, field)

	return json.RawMessage("{" + strings.Join(fields, ",") + "}"), nil
}
func (this *PlantationSerializer) SetToJson(plantations []*mdl.Plantation) (json.RawMessage, error) {

	var jsonStrings []string
	for _, plantation := range plantations {
		j, err := this.OneToJson(plantation)
		if err != nil {
			return json.RawMessage(""), err
		}
		jsonStrings = append(jsonStrings, string(j))
	}
	return json.RawMessage("[" + strings.Join(jsonStrings, ",") + "]"), nil
}
