package serializers

// |@@| C

import (
	"encoding/json"
	"gardening/src/lib/to_json"
	"gardening/src/mdl"
	"strings"
)

type SeedProgramSerializer struct {
}

func (this *SeedProgramSerializer) OneToJson(seedProgram *mdl.SeedProgram) (json.RawMessage, error) {

	var fields []string
	var field string
	field, _ = to_json.StringField("id", seedProgram.Id)
	fields = append(fields, field)
	field, _ = to_json.TimeField("created_at", seedProgram.CreatedAt)
	fields = append(fields, field)
	field, _ = to_json.TimeField("updated_at", seedProgram.UpdatedAt)
	fields = append(fields, field)
	field, _ = to_json.StringField("contact", seedProgram.Contact)
	fields = append(fields, field)
	field, _ = to_json.StringField("description", seedProgram.Description)
	fields = append(fields, field)
	field, _ = to_json.StringField("name", seedProgram.Name)
	fields = append(fields, field)
	field, _ = to_json.StringField("plant_id", seedProgram.PlantId)
	fields = append(fields, field)

	return json.RawMessage("{" + strings.Join(fields, ",") + "}"), nil
}
func (this *SeedProgramSerializer) SetToJson(seedPrograms []*mdl.SeedProgram) (json.RawMessage, error) {

	var jsonStrings []string
	for _, seedProgram := range seedPrograms {
		j, err := this.OneToJson(seedProgram)
		if err != nil {
			return json.RawMessage(""), err
		}
		jsonStrings = append(jsonStrings, string(j))
	}
	return json.RawMessage("[" + strings.Join(jsonStrings, ",") + "]"), nil
}
