package serializers

// |@@| C

import (
	"encoding/json"
	"gardening/src/lib/to_json"
	"gardening/src/mdl"
	"strings"
)

type UserSerializer struct {
}

func (this *UserSerializer) OneToJson(user *mdl.User) (json.RawMessage, error) {

	var fields []string
	var field string
	field, _ = to_json.StringField("id", user.Id)
	fields = append(fields, field)
	field, _ = to_json.TimeField("created_at", user.CreatedAt)
	fields = append(fields, field)
	field, _ = to_json.TimeField("updated_at", user.UpdatedAt)
	fields = append(fields, field)
	field, _ = to_json.StringField("name", user.Name)
	fields = append(fields, field)

	return json.RawMessage("{" + strings.Join(fields, ",") + "}"), nil
}
func (this *UserSerializer) SetToJson(users []*mdl.User) (json.RawMessage, error) {

	var jsonStrings []string
	for _, user := range users {
		j, err := this.OneToJson(user)
		if err != nil {
			return json.RawMessage(""), err
		}
		jsonStrings = append(jsonStrings, string(j))
	}
	return json.RawMessage("[" + strings.Join(jsonStrings, ",") + "]"), nil
}
