package show_presenters

// |@@| C

import (
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type GardenShowPresenter struct {
	Kit *kit.Kit
}

func (this *GardenShowPresenter) idField(entity *mdl.Garden) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Id)
}
func (this *GardenShowPresenter) createdAtField(entity *mdl.Garden) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.CreatedAt.Format("02/01/2006 15:04"))
}
func (this *GardenShowPresenter) updatedAtField(entity *mdl.Garden) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.UpdatedAt.Format("02/01/2006 15:04"))
}
func (this *GardenShowPresenter) nameField(entity *mdl.Garden) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Name)
}
func (this *GardenShowPresenter) pictureField(entity *mdl.Garden) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Picture)
}
func (this *GardenShowPresenter) FieldByKey(key string, entity *mdl.Garden) goc.HTML {
	switch key {
	case "id":
		return this.idField(entity)
	case "created_at":
		return this.createdAtField(entity)
	case "updated_at":
		return this.updatedAtField(entity)
	case "name":
		return this.nameField(entity)
	case "picture":
		return this.pictureField(entity)
	}
	panic(erro.N("Invalid field").KV("key", key))
}
