package show_presenters

// |@@| C

import (
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type GardenTaskShowPresenter struct {
	AppUrler           *urlers.AppUrler
	GardenStringer     *stringers.GardenStringer
	Kit                *kit.Kit
	PlantationStringer *stringers.PlantationStringer
}

func (this *GardenTaskShowPresenter) idField(entity *mdl.GardenTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Id)
}
func (this *GardenTaskShowPresenter) createdAtField(entity *mdl.GardenTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.CreatedAt.Format("02/01/2006 15:04"))
}
func (this *GardenTaskShowPresenter) updatedAtField(entity *mdl.GardenTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.UpdatedAt.Format("02/01/2006 15:04"))
}
func (this *GardenTaskShowPresenter) descriptionField(entity *mdl.GardenTask) goc.HTML {
	return this.Kit.Atoms.Cells.RichTextCell.RichTextCell(entity.Description)
}
func (this *GardenTaskShowPresenter) nameField(entity *mdl.GardenTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Name)
}
func (this *GardenTaskShowPresenter) startDateField(entity *mdl.GardenTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.StartDate.Format("02/01/2006 15:04"))
}
func (this *GardenTaskShowPresenter) gardenIdField(entity *mdl.GardenTask) goc.HTML {
	if entity.Garden == nil {
		return goc.HTML{}
	}
	return this.Kit.Atoms.Cells.RelationCell.RelationCell(entity.Garden.Id, this.GardenStringer.MustToString(entity.Garden), this.AppUrler.ShowGarden(entity.Garden.Id))
}
func (this *GardenTaskShowPresenter) plantationIdField(entity *mdl.GardenTask) goc.HTML {
	if entity.Plantation == nil {
		return goc.HTML{}
	}
	return this.Kit.Atoms.Cells.RelationCell.RelationCell(entity.Plantation.Id, this.PlantationStringer.MustToString(entity.Plantation), this.AppUrler.ShowPlantation(entity.Plantation.Id))
}
func (this *GardenTaskShowPresenter) FieldByKey(key string, entity *mdl.GardenTask) goc.HTML {
	switch key {
	case "id":
		return this.idField(entity)
	case "created_at":
		return this.createdAtField(entity)
	case "updated_at":
		return this.updatedAtField(entity)
	case "description":
		return this.descriptionField(entity)
	case "name":
		return this.nameField(entity)
	case "start_date":
		return this.startDateField(entity)
	case "garden_id":
		return this.gardenIdField(entity)
	case "plantation_id":
		return this.plantationIdField(entity)
	}
	panic(erro.N("Invalid field").KV("key", key))
}
