package show_presenters

// |@@| C

import (
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type PlantShowPresenter struct {
	Kit *kit.Kit
}

func (this *PlantShowPresenter) idField(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Id)
}
func (this *PlantShowPresenter) createdAtField(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.CreatedAt.Format("02/01/2006 15:04"))
}
func (this *PlantShowPresenter) updatedAtField(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.UpdatedAt.Format("02/01/2006 15:04"))
}
func (this *PlantShowPresenter) dataField(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.JsonCell.JsonCell(entity.Data)
}
func (this *PlantShowPresenter) descriptionField(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.RichTextCell.RichTextCell(entity.Description)
}
func (this *PlantShowPresenter) expositionField(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Exposition)
}
func (this *PlantShowPresenter) harvestedField(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.DecimalCell.DecimalCell(entity.Harvested)
}
func (this *PlantShowPresenter) nameField(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Name)
}
func (this *PlantShowPresenter) perennialField(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.BooleanCell.BooleanCell(entity.Perennial)
}
func (this *PlantShowPresenter) plantingSchemaField(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell("WIP")
}
func (this *PlantShowPresenter) referenceField(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Reference)
}
func (this *PlantShowPresenter) sizeField(entity *mdl.Plant) goc.HTML {
	return this.Kit.Atoms.Cells.IntegerCell.IntegerCell(entity.Size)
}
func (this *PlantShowPresenter) FieldByKey(key string, entity *mdl.Plant) goc.HTML {
	switch key {
	case "id":
		return this.idField(entity)
	case "created_at":
		return this.createdAtField(entity)
	case "updated_at":
		return this.updatedAtField(entity)
	case "data":
		return this.dataField(entity)
	case "description":
		return this.descriptionField(entity)
	case "exposition":
		return this.expositionField(entity)
	case "harvested":
		return this.harvestedField(entity)
	case "name":
		return this.nameField(entity)
	case "perennial":
		return this.perennialField(entity)
	case "planting_schema":
		return this.plantingSchemaField(entity)
	case "reference":
		return this.referenceField(entity)
	case "size":
		return this.sizeField(entity)
	}
	panic(erro.N("Invalid field").KV("key", key))
}
