package show_presenters

// |@@| C

import (
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type PlantTaskShowPresenter struct {
	AppUrler      *urlers.AppUrler
	Kit           *kit.Kit
	PlantStringer *stringers.PlantStringer
}

func (this *PlantTaskShowPresenter) idField(entity *mdl.PlantTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Id)
}
func (this *PlantTaskShowPresenter) createdAtField(entity *mdl.PlantTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.CreatedAt.Format("02/01/2006 15:04"))
}
func (this *PlantTaskShowPresenter) updatedAtField(entity *mdl.PlantTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.UpdatedAt.Format("02/01/2006 15:04"))
}
func (this *PlantTaskShowPresenter) descriptionField(entity *mdl.PlantTask) goc.HTML {
	return this.Kit.Atoms.Cells.RichTextCell.RichTextCell(entity.Description)
}
func (this *PlantTaskShowPresenter) nameField(entity *mdl.PlantTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Name)
}
func (this *PlantTaskShowPresenter) startDateField(entity *mdl.PlantTask) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.StartDate.Format("02/01/2006 15:04"))
}
func (this *PlantTaskShowPresenter) plantIdField(entity *mdl.PlantTask) goc.HTML {
	if entity.Plant == nil {
		return goc.HTML{}
	}
	return this.Kit.Atoms.Cells.RelationCell.RelationCell(entity.Plant.Id, this.PlantStringer.MustToString(entity.Plant), this.AppUrler.ShowPlant(entity.Plant.Id))
}
func (this *PlantTaskShowPresenter) FieldByKey(key string, entity *mdl.PlantTask) goc.HTML {
	switch key {
	case "id":
		return this.idField(entity)
	case "created_at":
		return this.createdAtField(entity)
	case "updated_at":
		return this.updatedAtField(entity)
	case "description":
		return this.descriptionField(entity)
	case "name":
		return this.nameField(entity)
	case "start_date":
		return this.startDateField(entity)
	case "plant_id":
		return this.plantIdField(entity)
	}
	panic(erro.N("Invalid field").KV("key", key))
}
