package show_presenters

// |@@| C

import (
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type PlantationShowPresenter struct {
	AppUrler       *urlers.AppUrler
	GardenStringer *stringers.GardenStringer
	Kit            *kit.Kit
	PlantStringer  *stringers.PlantStringer
}

func (this *PlantationShowPresenter) idField(entity *mdl.Plantation) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Id)
}
func (this *PlantationShowPresenter) createdAtField(entity *mdl.Plantation) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.CreatedAt.Format("02/01/2006 15:04"))
}
func (this *PlantationShowPresenter) updatedAtField(entity *mdl.Plantation) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.UpdatedAt.Format("02/01/2006 15:04"))
}
func (this *PlantationShowPresenter) nameField(entity *mdl.Plantation) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Name)
}
func (this *PlantationShowPresenter) plantedAtField(entity *mdl.Plantation) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.PlantedAt.Format("02/01/2006 15:04"))
}
func (this *PlantationShowPresenter) plantIdField(entity *mdl.Plantation) goc.HTML {
	if entity.Plant == nil {
		return goc.HTML{}
	}
	return this.Kit.Atoms.Cells.RelationCell.RelationCell(entity.Plant.Id, this.PlantStringer.MustToString(entity.Plant), this.AppUrler.ShowPlant(entity.Plant.Id))
}
func (this *PlantationShowPresenter) gardenIdField(entity *mdl.Plantation) goc.HTML {
	if entity.Garden == nil {
		return goc.HTML{}
	}
	return this.Kit.Atoms.Cells.RelationCell.RelationCell(entity.Garden.Id, this.GardenStringer.MustToString(entity.Garden), this.AppUrler.ShowGarden(entity.Garden.Id))
}
func (this *PlantationShowPresenter) FieldByKey(key string, entity *mdl.Plantation) goc.HTML {
	switch key {
	case "id":
		return this.idField(entity)
	case "created_at":
		return this.createdAtField(entity)
	case "updated_at":
		return this.updatedAtField(entity)
	case "name":
		return this.nameField(entity)
	case "planted_at":
		return this.plantedAtField(entity)
	case "plant_id":
		return this.plantIdField(entity)
	case "garden_id":
		return this.gardenIdField(entity)
	}
	panic(erro.N("Invalid field").KV("key", key))
}
