package show_presenters

// |@@| C

import (
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gardening/src/srv/stringers"
	"gardening/src/srv/urlers"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type SeedProgramShowPresenter struct {
	AppUrler      *urlers.AppUrler
	Kit           *kit.Kit
	PlantStringer *stringers.PlantStringer
}

func (this *SeedProgramShowPresenter) idField(entity *mdl.SeedProgram) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Id)
}
func (this *SeedProgramShowPresenter) createdAtField(entity *mdl.SeedProgram) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.CreatedAt.Format("02/01/2006 15:04"))
}
func (this *SeedProgramShowPresenter) updatedAtField(entity *mdl.SeedProgram) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.UpdatedAt.Format("02/01/2006 15:04"))
}
func (this *SeedProgramShowPresenter) contactField(entity *mdl.SeedProgram) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Contact)
}
func (this *SeedProgramShowPresenter) descriptionField(entity *mdl.SeedProgram) goc.HTML {
	return this.Kit.Atoms.Cells.RichTextCell.RichTextCell(entity.Description)
}
func (this *SeedProgramShowPresenter) nameField(entity *mdl.SeedProgram) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Name)
}
func (this *SeedProgramShowPresenter) plantIdField(entity *mdl.SeedProgram) goc.HTML {
	if entity.Plant == nil {
		return goc.HTML{}
	}
	return this.Kit.Atoms.Cells.RelationCell.RelationCell(entity.Plant.Id, this.PlantStringer.MustToString(entity.Plant), this.AppUrler.ShowPlant(entity.Plant.Id))
}
func (this *SeedProgramShowPresenter) FieldByKey(key string, entity *mdl.SeedProgram) goc.HTML {
	switch key {
	case "id":
		return this.idField(entity)
	case "created_at":
		return this.createdAtField(entity)
	case "updated_at":
		return this.updatedAtField(entity)
	case "contact":
		return this.contactField(entity)
	case "description":
		return this.descriptionField(entity)
	case "name":
		return this.nameField(entity)
	case "plant_id":
		return this.plantIdField(entity)
	}
	panic(erro.N("Invalid field").KV("key", key))
}
