package show_presenters

// |@@| C

import (
	"gardening/src/lib/error"
	"gardening/src/lib/kit"
	"gardening/src/mdl"
	"gitlab.com/ccyrillee/kitcla/goc"
)

type UserShowPresenter struct {
	Kit *kit.Kit
}

func (this *UserShowPresenter) idField(entity *mdl.User) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Id)
}
func (this *UserShowPresenter) createdAtField(entity *mdl.User) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.CreatedAt.Format("02/01/2006 15:04"))
}
func (this *UserShowPresenter) updatedAtField(entity *mdl.User) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.UpdatedAt.Format("02/01/2006 15:04"))
}
func (this *UserShowPresenter) nameField(entity *mdl.User) goc.HTML {
	return this.Kit.Atoms.Cells.TextCell.TextCell(entity.Name)
}
func (this *UserShowPresenter) FieldByKey(key string, entity *mdl.User) goc.HTML {
	switch key {
	case "id":
		return this.idField(entity)
	case "created_at":
		return this.createdAtField(entity)
	case "updated_at":
		return this.updatedAtField(entity)
	case "name":
		return this.nameField(entity)
	}
	panic(erro.N("Invalid field").KV("key", key))
}
