package stringers

// |@@| C

import (
	"errors"
	"gardening/src/mdl"
)

type Stringers struct {
	EventStringer       *EventStringer
	GardenStringer      *GardenStringer
	GardenTaskStringer  *GardenTaskStringer
	PlantStringer       *PlantStringer
	PlantTaskStringer   *PlantTaskStringer
	PlantationStringer  *PlantationStringer
	SeedProgramStringer *SeedProgramStringer
	UserStringer        *UserStringer
}

func (this *Stringers) ToString(object interface{}) (string, error) {
	switch v := object.(type) {
	case *mdl.Event:
		return this.EventStringer.ToString(v)
	case *mdl.Garden:
		return this.GardenStringer.ToString(v)
	case *mdl.GardenTask:
		return this.GardenTaskStringer.ToString(v)
	case *mdl.Plant:
		return this.PlantStringer.ToString(v)
	case *mdl.PlantTask:
		return this.PlantTaskStringer.ToString(v)
	case *mdl.Plantation:
		return this.PlantationStringer.ToString(v)
	case *mdl.SeedProgram:
		return this.SeedProgramStringer.ToString(v)
	case *mdl.User:
		return this.UserStringer.ToString(v)

	default:
		return "", errors.New("cannot convert the object into a string")
	}
}
