package tables

// |@@| C

import (
	"database/sql"
	"gardening/src/mdl"
)

type EventTable struct {
}

type EventEso struct {
	Id           string
	CreatedAt    sql.NullTime
	UpdatedAt    sql.NullTime
	What         string
	Who          string
	When         sql.NullTime
	Why          string
	ResourceId   string
	ResourceType string
}

func (this *EventTable) EsoToEntity(eso *EventEso) *mdl.Event {
	entity := &mdl.Event{}
	entity.Id = eso.Id
	entity.CreatedAt = eso.CreatedAt.Time
	entity.UpdatedAt = eso.UpdatedAt.Time
	entity.What = eso.What
	entity.Who = eso.Who
	entity.When = eso.When.Time
	entity.Why = eso.Why
	entity.ResourceId = eso.ResourceId
	entity.ResourceType = eso.ResourceType
	return entity
}
func (this *EventTable) EsoToPointers(eso *EventEso) []interface{} {
	var values []interface{}
	values = append(values,
		&eso.Id,
		&eso.CreatedAt,
		&eso.UpdatedAt,
		&eso.What,
		&eso.Who,
		&eso.When,
		&eso.Why,
		&eso.ResourceId,
		&eso.ResourceType,
	)
	return values
}
func (this *EventTable) TableName() string {
	return "events"
}
func (this *EventTable) Columns() []string {
	return []string{"id", "created_at", "updated_at", "what", "who", "when", "why", "resource_id", "resource_type"}
}
func (this *EventTable) Fields() []string {
	return []string{"Id", "CreatedAt", "UpdatedAt", "What", "Who", "When", "Why", "ResourceId", "ResourceType"}
}
func (this *EventTable) ColumnsWithoutId() []string {
	columns := this.Columns()
	for i, column := range columns {
		if column == "id" {
			columns = append(columns[:i], columns[i+1:]...)
			break
		}
	}
	return columns
}
func (this *EventTable) EntityToValues(entity *mdl.Event) []interface{} {
	var values []interface{}
	values = append(values,
		entity.Id,
		entity.CreatedAt,
		entity.UpdatedAt,
		entity.What,
		entity.Who,
		entity.When,
		entity.Why,
		entity.ResourceId,
		entity.ResourceType)
	return values
}
