package tables

// |@@| C

import (
	"database/sql"
	"gardening/src/mdl"
)

type GardenTable struct {
}

type GardenEso struct {
	Id        string
	CreatedAt sql.NullTime
	UpdatedAt sql.NullTime
	Name      string
	Picture   string
}

func (this *GardenTable) EsoToEntity(eso *GardenEso) *mdl.Garden {
	entity := &mdl.Garden{}
	entity.Id = eso.Id
	entity.CreatedAt = eso.CreatedAt.Time
	entity.UpdatedAt = eso.UpdatedAt.Time
	entity.Name = eso.Name
	entity.Picture = eso.Picture
	return entity
}
func (this *GardenTable) EsoToPointers(eso *GardenEso) []interface{} {
	var values []interface{}
	values = append(values,
		&eso.Id,
		&eso.CreatedAt,
		&eso.UpdatedAt,
		&eso.Name,
		&eso.Picture,
	)
	return values
}
func (this *GardenTable) TableName() string {
	return "gardens"
}
func (this *GardenTable) Columns() []string {
	return []string{"id", "created_at", "updated_at", "name", "picture"}
}
func (this *GardenTable) Fields() []string {
	return []string{"Id", "CreatedAt", "UpdatedAt", "Name", "Picture"}
}
func (this *GardenTable) ColumnsWithoutId() []string {
	columns := this.Columns()
	for i, column := range columns {
		if column == "id" {
			columns = append(columns[:i], columns[i+1:]...)
			break
		}
	}
	return columns
}
func (this *GardenTable) EntityToValues(entity *mdl.Garden) []interface{} {
	var values []interface{}
	values = append(values,
		entity.Id,
		entity.CreatedAt,
		entity.UpdatedAt,
		entity.Name,
		entity.Picture)
	return values
}
