package tables

// |@@| C

import (
	"database/sql"
	"gardening/src/mdl"
)

type GardenTaskTable struct {
}

type GardenTaskEso struct {
	Id           string
	CreatedAt    sql.NullTime
	UpdatedAt    sql.NullTime
	Description  string
	Name         string
	StartDate    sql.NullTime
	GardenId     sql.NullString
	PlantationId sql.NullString
}

func (this *GardenTaskTable) EsoToEntity(eso *GardenTaskEso) *mdl.GardenTask {
	entity := &mdl.GardenTask{}
	entity.Id = eso.Id
	entity.CreatedAt = eso.CreatedAt.Time
	entity.UpdatedAt = eso.UpdatedAt.Time
	entity.Description = eso.Description
	entity.Name = eso.Name
	entity.StartDate = eso.StartDate.Time
	entity.GardenId = eso.GardenId.String
	entity.PlantationId = eso.PlantationId.String
	return entity
}
func (this *GardenTaskTable) EsoToPointers(eso *GardenTaskEso) []interface{} {
	var values []interface{}
	values = append(values,
		&eso.Id,
		&eso.CreatedAt,
		&eso.UpdatedAt,
		&eso.Description,
		&eso.Name,
		&eso.StartDate,
		&eso.GardenId,
		&eso.PlantationId,
	)
	return values
}
func (this *GardenTaskTable) TableName() string {
	return "garden_tasks"
}
func (this *GardenTaskTable) Columns() []string {
	return []string{"id", "created_at", "updated_at", "description", "name", "start_date", "garden_id", "plantation_id"}
}
func (this *GardenTaskTable) Fields() []string {
	return []string{"Id", "CreatedAt", "UpdatedAt", "Description", "Name", "StartDate", "GardenId", "PlantationId"}
}
func (this *GardenTaskTable) ColumnsWithoutId() []string {
	columns := this.Columns()
	for i, column := range columns {
		if column == "id" {
			columns = append(columns[:i], columns[i+1:]...)
			break
		}
	}
	return columns
}
func (this *GardenTaskTable) EntityToValues(entity *mdl.GardenTask) []interface{} {
	var values []interface{}
	values = append(values,
		entity.Id,
		entity.CreatedAt,
		entity.UpdatedAt,
		entity.Description,
		entity.Name,
		entity.StartDate,
		sql.NullString{String: entity.GardenId, Valid: entity.GardenId != ""},
		sql.NullString{String: entity.PlantationId, Valid: entity.PlantationId != ""})
	return values
}
