package tables

// |@@| C

import (
	"database/sql"
	"gardening/src/lib/jsoner"
	"gardening/src/mdl"
)

type PlantTable struct {
	Jsoner *jsoner.Jsoner
}

type PlantEso struct {
	Id             string
	CreatedAt      sql.NullTime
	UpdatedAt      sql.NullTime
	Data           []byte
	Description    string
	Exposition     string
	Harvested      float64
	Name           string
	Perennial      bool
	PlantingSchema []byte
	Reference      string
	Size           int
}

func (this *PlantTable) EsoToEntity(eso *PlantEso) *mdl.Plant {
	entity := &mdl.Plant{}
	entity.Id = eso.Id
	entity.CreatedAt = eso.CreatedAt.Time
	entity.UpdatedAt = eso.UpdatedAt.Time
	entity.Data = eso.Data
	entity.Description = eso.Description
	entity.Exposition = eso.Exposition
	entity.Harvested = eso.Harvested
	entity.Name = eso.Name
	entity.Perennial = eso.Perennial
	plantingSchema := mdl.PlantingSchema{}
	this.Jsoner.MustUnmarshal(eso.PlantingSchema, &plantingSchema)
	entity.PlantingSchema = plantingSchema
	entity.Reference = eso.Reference
	entity.Size = eso.Size
	return entity
}
func (this *PlantTable) EsoToPointers(eso *PlantEso) []interface{} {
	var values []interface{}
	values = append(values,
		&eso.Id,
		&eso.CreatedAt,
		&eso.UpdatedAt,
		&eso.Data,
		&eso.Description,
		&eso.Exposition,
		&eso.Harvested,
		&eso.Name,
		&eso.Perennial,
		&eso.PlantingSchema,
		&eso.Reference,
		&eso.Size,
	)
	return values
}
func (this *PlantTable) TableName() string {
	return "plants"
}
func (this *PlantTable) Columns() []string {
	return []string{"id", "created_at", "updated_at", "data", "description", "exposition", "harvested", "name", "perennial", "planting_schema", "reference", "size"}
}
func (this *PlantTable) Fields() []string {
	return []string{"Id", "CreatedAt", "UpdatedAt", "Data", "Description", "Exposition", "Harvested", "Name", "Perennial", "PlantingSchema", "Reference", "Size"}
}
func (this *PlantTable) ColumnsWithoutId() []string {
	columns := this.Columns()
	for i, column := range columns {
		if column == "id" {
			columns = append(columns[:i], columns[i+1:]...)
			break
		}
	}
	return columns
}
func (this *PlantTable) EntityToValues(entity *mdl.Plant) []interface{} {
	var values []interface{}
	plantingSchema := this.Jsoner.MustMarshal(entity.PlantingSchema)
	values = append(values,
		entity.Id,
		entity.CreatedAt,
		entity.UpdatedAt,
		entity.Data,
		entity.Description,
		entity.Exposition,
		entity.Harvested,
		entity.Name,
		entity.Perennial,
		plantingSchema,
		entity.Reference,
		entity.Size)
	return values
}
