package tables

// |@@| C

import (
	"database/sql"
	"gardening/src/mdl"
)

type PlantTaskTable struct {
}

type PlantTaskEso struct {
	Id          string
	CreatedAt   sql.NullTime
	UpdatedAt   sql.NullTime
	Description string
	Name        string
	StartDate   sql.NullTime
	PlantId     sql.NullString
}

func (this *PlantTaskTable) EsoToEntity(eso *PlantTaskEso) *mdl.PlantTask {
	entity := &mdl.PlantTask{}
	entity.Id = eso.Id
	entity.CreatedAt = eso.CreatedAt.Time
	entity.UpdatedAt = eso.UpdatedAt.Time
	entity.Description = eso.Description
	entity.Name = eso.Name
	entity.StartDate = eso.StartDate.Time
	entity.PlantId = eso.PlantId.String
	return entity
}
func (this *PlantTaskTable) EsoToPointers(eso *PlantTaskEso) []interface{} {
	var values []interface{}
	values = append(values,
		&eso.Id,
		&eso.CreatedAt,
		&eso.UpdatedAt,
		&eso.Description,
		&eso.Name,
		&eso.StartDate,
		&eso.PlantId,
	)
	return values
}
func (this *PlantTaskTable) TableName() string {
	return "plant_tasks"
}
func (this *PlantTaskTable) Columns() []string {
	return []string{"id", "created_at", "updated_at", "description", "name", "start_date", "plant_id"}
}
func (this *PlantTaskTable) Fields() []string {
	return []string{"Id", "CreatedAt", "UpdatedAt", "Description", "Name", "StartDate", "PlantId"}
}
func (this *PlantTaskTable) ColumnsWithoutId() []string {
	columns := this.Columns()
	for i, column := range columns {
		if column == "id" {
			columns = append(columns[:i], columns[i+1:]...)
			break
		}
	}
	return columns
}
func (this *PlantTaskTable) EntityToValues(entity *mdl.PlantTask) []interface{} {
	var values []interface{}
	values = append(values,
		entity.Id,
		entity.CreatedAt,
		entity.UpdatedAt,
		entity.Description,
		entity.Name,
		entity.StartDate,
		sql.NullString{String: entity.PlantId, Valid: entity.PlantId != ""})
	return values
}
