package tables

// |@@| C

import (
	"database/sql"
	"gardening/src/mdl"
)

type PlantationTable struct {
}

type PlantationEso struct {
	Id        string
	CreatedAt sql.NullTime
	UpdatedAt sql.NullTime
	Name      string
	PlantedAt sql.NullTime
	PlantId   sql.NullString
	GardenId  sql.NullString
}

func (this *PlantationTable) EsoToEntity(eso *PlantationEso) *mdl.Plantation {
	entity := &mdl.Plantation{}
	entity.Id = eso.Id
	entity.CreatedAt = eso.CreatedAt.Time
	entity.UpdatedAt = eso.UpdatedAt.Time
	entity.Name = eso.Name
	entity.PlantedAt = eso.PlantedAt.Time
	entity.PlantId = eso.PlantId.String
	entity.GardenId = eso.GardenId.String
	return entity
}
func (this *PlantationTable) EsoToPointers(eso *PlantationEso) []interface{} {
	var values []interface{}
	values = append(values,
		&eso.Id,
		&eso.CreatedAt,
		&eso.UpdatedAt,
		&eso.Name,
		&eso.PlantedAt,
		&eso.PlantId,
		&eso.GardenId,
	)
	return values
}
func (this *PlantationTable) TableName() string {
	return "plantations"
}
func (this *PlantationTable) Columns() []string {
	return []string{"id", "created_at", "updated_at", "name", "planted_at", "plant_id", "garden_id"}
}
func (this *PlantationTable) Fields() []string {
	return []string{"Id", "CreatedAt", "UpdatedAt", "Name", "PlantedAt", "PlantId", "GardenId"}
}
func (this *PlantationTable) ColumnsWithoutId() []string {
	columns := this.Columns()
	for i, column := range columns {
		if column == "id" {
			columns = append(columns[:i], columns[i+1:]...)
			break
		}
	}
	return columns
}
func (this *PlantationTable) EntityToValues(entity *mdl.Plantation) []interface{} {
	var values []interface{}
	values = append(values,
		entity.Id,
		entity.CreatedAt,
		entity.UpdatedAt,
		entity.Name,
		entity.PlantedAt,
		sql.NullString{String: entity.PlantId, Valid: entity.PlantId != ""},
		sql.NullString{String: entity.GardenId, Valid: entity.GardenId != ""})
	return values
}
