package tables

// |@@| C

import (
	"database/sql"
	"gardening/src/mdl"
)

type SeedProgramTable struct {
}

type SeedProgramEso struct {
	Id          string
	CreatedAt   sql.NullTime
	UpdatedAt   sql.NullTime
	Contact     string
	Description string
	Name        string
	PlantId     sql.NullString
}

func (this *SeedProgramTable) EsoToEntity(eso *SeedProgramEso) *mdl.SeedProgram {
	entity := &mdl.SeedProgram{}
	entity.Id = eso.Id
	entity.CreatedAt = eso.CreatedAt.Time
	entity.UpdatedAt = eso.UpdatedAt.Time
	entity.Contact = eso.Contact
	entity.Description = eso.Description
	entity.Name = eso.Name
	entity.PlantId = eso.PlantId.String
	return entity
}
func (this *SeedProgramTable) EsoToPointers(eso *SeedProgramEso) []interface{} {
	var values []interface{}
	values = append(values,
		&eso.Id,
		&eso.CreatedAt,
		&eso.UpdatedAt,
		&eso.Contact,
		&eso.Description,
		&eso.Name,
		&eso.PlantId,
	)
	return values
}
func (this *SeedProgramTable) TableName() string {
	return "seed_programs"
}
func (this *SeedProgramTable) Columns() []string {
	return []string{"id", "created_at", "updated_at", "contact", "description", "name", "plant_id"}
}
func (this *SeedProgramTable) Fields() []string {
	return []string{"Id", "CreatedAt", "UpdatedAt", "Contact", "Description", "Name", "PlantId"}
}
func (this *SeedProgramTable) ColumnsWithoutId() []string {
	columns := this.Columns()
	for i, column := range columns {
		if column == "id" {
			columns = append(columns[:i], columns[i+1:]...)
			break
		}
	}
	return columns
}
func (this *SeedProgramTable) EntityToValues(entity *mdl.SeedProgram) []interface{} {
	var values []interface{}
	values = append(values,
		entity.Id,
		entity.CreatedAt,
		entity.UpdatedAt,
		entity.Contact,
		entity.Description,
		entity.Name,
		sql.NullString{String: entity.PlantId, Valid: entity.PlantId != ""})
	return values
}
