package tables

// |@@| C

import (
	"database/sql"
	"gardening/src/mdl"
)

type UserTable struct {
}

type UserEso struct {
	Id        string
	CreatedAt sql.NullTime
	UpdatedAt sql.NullTime
	Name      string
}

func (this *UserTable) EsoToEntity(eso *UserEso) *mdl.User {
	entity := &mdl.User{}
	entity.Id = eso.Id
	entity.CreatedAt = eso.CreatedAt.Time
	entity.UpdatedAt = eso.UpdatedAt.Time
	entity.Name = eso.Name
	return entity
}
func (this *UserTable) EsoToPointers(eso *UserEso) []interface{} {
	var values []interface{}
	values = append(values,
		&eso.Id,
		&eso.CreatedAt,
		&eso.UpdatedAt,
		&eso.Name,
	)
	return values
}
func (this *UserTable) TableName() string {
	return "users"
}
func (this *UserTable) Columns() []string {
	return []string{"id", "created_at", "updated_at", "name"}
}
func (this *UserTable) Fields() []string {
	return []string{"Id", "CreatedAt", "UpdatedAt", "Name"}
}
func (this *UserTable) ColumnsWithoutId() []string {
	columns := this.Columns()
	for i, column := range columns {
		if column == "id" {
			columns = append(columns[:i], columns[i+1:]...)
			break
		}
	}
	return columns
}
func (this *UserTable) EntityToValues(entity *mdl.User) []interface{} {
	var values []interface{}
	values = append(values,
		entity.Id,
		entity.CreatedAt,
		entity.UpdatedAt,
		entity.Name)
	return values
}
