package urlers

// |@@| C

import (
	"gardening/src/lib/urler"
)

type AppUrler struct {
}

func (this *AppUrler) CreateGarden(params ...urler.UrlParam) string {
	return "/app/create-garden" + urler.Params(params)
}
func (this *AppUrler) CreateGardenTask(params ...urler.UrlParam) string {
	return "/app/create-garden-task" + urler.Params(params)
}
func (this *AppUrler) CreatePlant(params ...urler.UrlParam) string {
	return "/app/create-plant" + urler.Params(params)
}
func (this *AppUrler) CreatePlantTask(params ...urler.UrlParam) string {
	return "/app/create-plant-task" + urler.Params(params)
}
func (this *AppUrler) CreatePlantation(params ...urler.UrlParam) string {
	return "/app/create-plantation" + urler.Params(params)
}
func (this *AppUrler) CreateSeedProgram(params ...urler.UrlParam) string {
	return "/app/create-seed-program" + urler.Params(params)
}
func (this *AppUrler) CreateUser(params ...urler.UrlParam) string {
	return "/app/create-user" + urler.Params(params)
}
func (this *AppUrler) DeleteGarden(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("id", id)}, params...)
	return "/app/delete-garden" + urler.Params(params)
}
func (this *AppUrler) DeleteGardenTask(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("id", id)}, params...)
	return "/app/delete-garden-task" + urler.Params(params)
}
func (this *AppUrler) DeletePlant(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("id", id)}, params...)
	return "/app/delete-plant" + urler.Params(params)
}
func (this *AppUrler) DeletePlantTask(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("id", id)}, params...)
	return "/app/delete-plant-task" + urler.Params(params)
}
func (this *AppUrler) DeletePlantation(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("id", id)}, params...)
	return "/app/delete-plantation" + urler.Params(params)
}
func (this *AppUrler) DeleteSeedProgram(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("id", id)}, params...)
	return "/app/delete-seed-program" + urler.Params(params)
}
func (this *AppUrler) DeleteUser(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("id", id)}, params...)
	return "/app/delete-user" + urler.Params(params)
}
func (this *AppUrler) DisplayWeatherForecast(params ...urler.UrlParam) string {
	return "/app/display-weather-forecast" + urler.Params(params)
}
func (this *AppUrler) EditGarden(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("form[id]", id)}, params...)
	return "/app/edit-garden" + urler.Params(params)
}
func (this *AppUrler) EditGardenTask(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("form[id]", id)}, params...)
	return "/app/edit-garden-task" + urler.Params(params)
}
func (this *AppUrler) EditPlant(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("form[id]", id)}, params...)
	return "/app/edit-plant" + urler.Params(params)
}
func (this *AppUrler) EditPlantTask(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("form[id]", id)}, params...)
	return "/app/edit-plant-task" + urler.Params(params)
}
func (this *AppUrler) EditPlantation(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("form[id]", id)}, params...)
	return "/app/edit-plantation" + urler.Params(params)
}
func (this *AppUrler) EditSeedProgram(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("form[id]", id)}, params...)
	return "/app/edit-seed-program" + urler.Params(params)
}
func (this *AppUrler) EditUser(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("form[id]", id)}, params...)
	return "/app/edit-user" + urler.Params(params)
}
func (this *AppUrler) Home(params ...urler.UrlParam) string {
	return "/app/" + urler.Params(params)
}
func (this *AppUrler) InstructPlanner(params ...urler.UrlParam) string {
	return "/app/instruct-planner" + urler.Params(params)
}
func (this *AppUrler) ListGardenTasks(params ...urler.UrlParam) string {
	return "/app/list-garden-tasks" + urler.Params(params)
}
func (this *AppUrler) ListGardens(params ...urler.UrlParam) string {
	return "/app/list-gardens" + urler.Params(params)
}
func (this *AppUrler) ListPlantTasks(params ...urler.UrlParam) string {
	return "/app/list-plant-tasks" + urler.Params(params)
}
func (this *AppUrler) ListPlantations(params ...urler.UrlParam) string {
	return "/app/list-plantations" + urler.Params(params)
}
func (this *AppUrler) ListPlants(params ...urler.UrlParam) string {
	return "/app/list-plants" + urler.Params(params)
}
func (this *AppUrler) ListSeedPrograms(params ...urler.UrlParam) string {
	return "/app/list-seed-programs" + urler.Params(params)
}
func (this *AppUrler) ListUsers(params ...urler.UrlParam) string {
	return "/app/list-users" + urler.Params(params)
}
func (this *AppUrler) NewGarden(params ...urler.UrlParam) string {
	return "/app/new-garden" + urler.Params(params)
}
func (this *AppUrler) NewGardenTask(params ...urler.UrlParam) string {
	return "/app/new-garden-task" + urler.Params(params)
}
func (this *AppUrler) NewPlant(params ...urler.UrlParam) string {
	return "/app/new-plant" + urler.Params(params)
}
func (this *AppUrler) NewPlantTask(params ...urler.UrlParam) string {
	return "/app/new-plant-task" + urler.Params(params)
}
func (this *AppUrler) NewPlantation(params ...urler.UrlParam) string {
	return "/app/new-plantation" + urler.Params(params)
}
func (this *AppUrler) NewSeedProgram(params ...urler.UrlParam) string {
	return "/app/new-seed-program" + urler.Params(params)
}
func (this *AppUrler) NewUser(params ...urler.UrlParam) string {
	return "/app/new-user" + urler.Params(params)
}
func (this *AppUrler) OverviewStorage(params ...urler.UrlParam) string {
	return "/app/overview-storage" + urler.Params(params)
}
func (this *AppUrler) PerformAnalyse(params ...urler.UrlParam) string {
	return "/app/perform-analyse" + urler.Params(params)
}
func (this *AppUrler) PerformImagesRoutine(params ...urler.UrlParam) string {
	return "/app/perform-images-routine" + urler.Params(params)
}
func (this *AppUrler) PerformRenewOrders(params ...urler.UrlParam) string {
	return "/app/perform-renew-orders" + urler.Params(params)
}
func (this *AppUrler) SeeEvents(params ...urler.UrlParam) string {
	return "/app/see-events" + urler.Params(params)
}
func (this *AppUrler) SeePlanner(params ...urler.UrlParam) string {
	return "/app/see-planner" + urler.Params(params)
}
func (this *AppUrler) SeeRenewOrders(params ...urler.UrlParam) string {
	return "/app/see-renew-orders" + urler.Params(params)
}
func (this *AppUrler) ShowGarden(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("id", id)}, params...)
	return "/app/show-garden" + urler.Params(params)
}
func (this *AppUrler) ShowGardenTask(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("id", id)}, params...)
	return "/app/show-garden-task" + urler.Params(params)
}
func (this *AppUrler) ShowPlant(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("id", id)}, params...)
	return "/app/show-plant" + urler.Params(params)
}
func (this *AppUrler) ShowPlantTask(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("id", id)}, params...)
	return "/app/show-plant-task" + urler.Params(params)
}
func (this *AppUrler) ShowPlantation(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("id", id)}, params...)
	return "/app/show-plantation" + urler.Params(params)
}
func (this *AppUrler) ShowSeedProgram(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("id", id)}, params...)
	return "/app/show-seed-program" + urler.Params(params)
}
func (this *AppUrler) ShowUser(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("id", id)}, params...)
	return "/app/show-user" + urler.Params(params)
}
func (this *AppUrler) UpdateGarden(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("form[id]", id)}, params...)
	return "/app/update-garden" + urler.Params(params)
}
func (this *AppUrler) UpdateGardenTask(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("form[id]", id)}, params...)
	return "/app/update-garden-task" + urler.Params(params)
}
func (this *AppUrler) UpdatePlant(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("form[id]", id)}, params...)
	return "/app/update-plant" + urler.Params(params)
}
func (this *AppUrler) UpdatePlantTask(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("form[id]", id)}, params...)
	return "/app/update-plant-task" + urler.Params(params)
}
func (this *AppUrler) UpdatePlantation(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("form[id]", id)}, params...)
	return "/app/update-plantation" + urler.Params(params)
}
func (this *AppUrler) UpdateSeedProgram(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("form[id]", id)}, params...)
	return "/app/update-seed-program" + urler.Params(params)
}
func (this *AppUrler) UpdateUser(id string, params ...urler.UrlParam) string {
	params = append([]urler.UrlParam{urler.StringParam("form[id]", id)}, params...)
	return "/app/update-user" + urler.Params(params)
}
