package canister

// |@@| C

import (
	"gardening/src/lib/operating_system"
	"gardening/sup/lib/asserter"
	"gardening/sup/lib/booker"
	"gardening/sup/lib/dotor"
	"gardening/sup/lib/exec"
	"gardening/sup/lib/reporter"
	"gardening/sup/lib/seeder"
	"gardening/sup/lib/stater"
	"gardening/sup/lib/storyteller"
	"gardening/sup/lib/test_helper"
	"gardening/sup/lib/web_driver"
	"gardening/sup/srv/seeders"
	"gardening/sup/srv/staters"
)

type Canister struct {
	Asserter                    *asserter.Asserter
	BaseStater                  *staters.BaseStater
	Booker                      *booker.Booker
	DevStater                   *staters.DevStater
	EventSeeder                 *seeders.EventSeeder
	FilesystemAsserter          *asserter.FilesystemAsserter
	GardenSeeder                *seeders.GardenSeeder
	GardenTaskSeeder            *seeders.GardenTaskSeeder
	GrownStater                 *staters.GrownStater
	MemoryOperatingSystemIpl    *operating_system.MemoryOperatingSystemIpl
	MemoryOperatingSystemSpyIpl *operating_system.MemoryOperatingSystemSpyIpl
	MockExecIpl                 *exec.MockExecIpl
	PlantSeeder                 *seeders.PlantSeeder
	PlantTaskSeeder             *seeders.PlantTaskSeeder
	PlantationSeeder            *seeders.PlantationSeeder
	ProdStater                  *staters.ProdStater
	ReadyStater                 *staters.ReadyStater
	Reporter                    *reporter.Reporter
	SeedProgramSeeder           *seeders.SeedProgramSeeder
	Seeder                      *seeder.Seeder
	Seeders                     *seeders.Seeders
	Stater                      *stater.Stater
	Storyteller                 *storyteller.Storyteller
	SupportDotor                *dotor.SupportDotor
	TestHelper                  *test_helper.TestHelper
	UserSeeder                  *seeders.UserSeeder
	WebDriver                   *web_driver.WebDriver
}

func (this *Canister) Self() {
}
