package helpers

// |@@| C

import (
	"context"
	"gardening/src/app/container"
	"gardening/sup/canister"
)

func DefaultConfiguration(ctx context.Context, c *container.Container, ca *canister.Canister) {
	ca.SupportDotor.Act(ctx)
}

func DefaultTestConfiguration(ctx context.Context, c *container.Container, ca *canister.Canister) {
	c.OperatingSystemInterface.Setenv(ctx, "ENV", "test")
	ca.SupportDotor.Act(ctx)
	c.WebServer.SetPort("3064")
}
