package helpers

// |@@| C

import (
	"context"
	"gardening/src/app/container"
	"gardening/sup/canister"
	"testing"
)

func NewCustomScene(mod *ContainerMod) (context.Context, *canister.Canister, *container.Container) {
	ctx := context.Background()

	c, ca := construct()

	configureBuiltServices(c, ca)
	configureInterfaces(c, ca, mod)

	inject(c, ca)

	DefaultConfiguration(ctx, c, ca)
	return ctx, ca, c
}

func NewDefaultCanisterScene() (context.Context, *canister.Canister, *container.Container) {
	ctx := context.Background()

	c, ca := construct()

	configureBuiltServices(c, ca)
	configureInterfacesReal(c, ca)

	inject(c, ca)

	DefaultConfiguration(ctx, c, ca)
	return ctx, ca, c
}

func NewIsolationTesterScene(t *testing.T) (context.Context, *canister.Canister, *container.Container) {
	ctx := context.Background()
	ctx = context.WithValue(ctx, "t", t)

	c, ca := construct()

	configureBuiltServices(c, ca)
	configureInterfacesIsolation(c, ca)

	inject(c, ca)

	DefaultTestConfiguration(ctx, c, ca)
	return ctx, ca, c
}

func construct() (*container.Container, *canister.Canister) {
	c := &container.Container{}
	ca := &canister.Canister{}

	c.ConstructContainer()
	ca.ConstructCanister()

	return c, ca
}

func inject(c *container.Container, ca *canister.Canister) {
	c.InjectContainer([]string{"Kit"})
	ca.InjectCanister(c)
}
