package reporter

import (
	"context"
	"gardening/src/lib/operating_system"
	"gardening/src/lib/spy"
)

type Reporter struct {
}

func (this *Reporter) FindRecordsSetByKinds(ctx context.Context, report *spy.Report, kinds []string) []*spy.Record {
	var records []*spy.Record
	for _, record := range report.Records {
		for _, kind := range kinds {
			if record.Kind == kind {
				records = append(records, record)
			}
		}
	}
	return records
}

func (this *Reporter) FindRecordsSetByKind(ctx context.Context, report *spy.Report, kind string) []*spy.Record {
	var records []*spy.Record
	for _, record := range report.Records {
		if record.Kind == kind {
			records = append(records, record)
		}
	}
	return records
}

func (this *Reporter) FindFilesWritten(ctx context.Context, report *spy.Report) []string {
	m := make(map[string]string)
	var paths []string

	records := this.FindRecordsSetByKind(ctx, report, "write-file")
	for _, record := range records {
		name := record.Data.(*operating_system.WriteFileDataSpyRecord).Name
		m[name] = name
	}
	for _, path := range m {
		paths = append(paths, path)
	}
	return paths
}
