package seeder

// |@@| C

import (
	"strconv"
	"time"
)

type Seeder struct {
}

func (this *Seeder) ObtainTimeValue(i int) time.Time {
	return time.Date(2021, 8, 15, 14, 30, 45, 100, time.Local)
}

func (this *Seeder) ObtainIncremantalIdValue(i int) string {
	return strconv.Itoa(i + 1)
}

func (this *Seeder) ObtainStringValue(i int, prefix string) string {
	return prefix + strconv.Itoa(i+1)
}

func (this *Seeder) ObtainDecimalValue(i int) float64 {
	return float64(i + 1)
}

func (this *Seeder) ObtainIntegerValue(i int) int {
	return i + 1
}

func (this *Seeder) ObtainEmptyJson() []byte {
	return []byte{}
}

func (this *Seeder) ObtainBooleanValue(i int) bool {
	if i%2 == 0 {
		return false
	}
	return true
}

func (this *Seeder) ObtainLoremIpsumTextValue() string {
	return `Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce sollicitudin diam et ipsum posuere dapibus. 
Ut gravida sapien nisl. Nullam mauris lorem, consectetur congue urna id, maximus lobortis quam.
Vestibulum a orci tellus. Etiam in dui in dolor egestas ullamcorper. Integer in bibendum eros, id euismod odio.
Sed lorem sapien, egestas at sollicitudin sed, ultrices sed risus.
Nullam mauris massa, pretium eu bibendum in, congue a velit. Nullam consectetur et nunc gravida aliquet.
Integer commodo tempus quam id tempus.`
}
