package test_helper

import (
	"gardening/src/lib"
	"os"
	"path/filepath"
	"runtime"
	"strings"
)

type TestHelper struct {
}

func (this *TestHelper) GetDataFileAsString(name string) (string, error) {
	testDirPath := this.testDirPath()
	filePath := filepath.Join(testDirPath, "data", name+".txt")
	b, err := os.ReadFile(filePath)
	lib.Poe(err)
	return string(b), nil
}

func (this *TestHelper) MustGetDataFileAsString(name string) string {
	s, err := this.GetDataFileAsString(name)
	lib.Poe(err)
	return s
}

func (this *TestHelper) testFilePath() string {
	for skip := 0; ; skip++ {
		_, file, _, ok := runtime.Caller(skip)
		if !ok {
			break
		}
		if strings.Count(file, "/tests/") > 0 && strings.HasSuffix(file, "_test.go") {
			return file
		}
	}
	panic("Unable to detect test file path")
}

func (this *TestHelper) testDirPath() string {
	return strings.TrimSuffix(this.testFilePath(), "_test.go")
}
