package seeders

// |@@| C

import (
	"context"
	"gardening/src/mdl"
	"gardening/src/srv/handlers"
	"gardening/sup/lib/seeder"
	"time"
)

type EventSeeder struct {
	EventHandler *handlers.EventHandler
	Seeder       *seeder.Seeder
}

func (this *EventSeeder) Seed(ctx context.Context) {
	for i := 0; i < 5; i++ {
		entity := &mdl.Event{
			CreatedAt:    this.createdAtColumn(ctx, i),
			UpdatedAt:    this.updatedAtColumn(ctx, i),
			What:         this.whatColumn(ctx, i),
			Who:          this.whoColumn(ctx, i),
			When:         this.whenColumn(ctx, i),
			Why:          this.whyColumn(ctx, i),
			ResourceId:   this.resourceIdColumn(ctx, i),
			ResourceType: this.resourceTypeColumn(ctx, i),
		}
		this.EventHandler.MustCreate(ctx, entity, nil)
	}
}
func (this *EventSeeder) createdAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *EventSeeder) updatedAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *EventSeeder) whatColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainStringValue(i, "Event What ")
}
func (this *EventSeeder) whoColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainStringValue(i, "Event Who ")
}
func (this *EventSeeder) whenColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *EventSeeder) whyColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainStringValue(i, "Event Why ")
}
func (this *EventSeeder) resourceIdColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainStringValue(i, "Event Resource ")
}
func (this *EventSeeder) resourceTypeColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainStringValue(i, "Event Resource Type ")
}
