package seeders

// |@@| C

import (
	"context"
	"gardening/src/mdl"
	"gardening/src/srv/handlers"
	"gardening/sup/lib/seeder"
	"strconv"
	"time"
)

type GardenSeeder struct {
	GardenHandler *handlers.GardenHandler
	Seeder        *seeder.Seeder
}

func (this *GardenSeeder) Seed(ctx context.Context) {
	for i := 0; i < 5; i++ {
		entity := &mdl.Garden{
			CreatedAt: this.createdAtColumn(ctx, i),
			UpdatedAt: this.updatedAtColumn(ctx, i),
			Name:      this.nameColumn(ctx, i),
			Picture:   this.pictureColumn(ctx, i),
		}
		this.GardenHandler.MustCreate(ctx, entity, nil)
	}
}
func (this *GardenSeeder) createdAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *GardenSeeder) updatedAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *GardenSeeder) nameColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainStringValue(i, "Garden Name ")
}
func (this *GardenSeeder) pictureColumn(ctx context.Context, i int) string {
	return "Garden Picture " + strconv.Itoa(i+1)
}
