package seeders

// |@@| C

import (
	"context"
	"gardening/src/mdl"
	"gardening/src/srv/handlers"
	"gardening/sup/lib/seeder"
	"strconv"
	"time"
)

type GardenTaskSeeder struct {
	GardenTaskHandler *handlers.GardenTaskHandler
	Seeder            *seeder.Seeder
}

func (this *GardenTaskSeeder) Seed(ctx context.Context) {
	for i := 0; i < 5; i++ {
		entity := &mdl.GardenTask{
			CreatedAt:    this.createdAtColumn(ctx, i),
			UpdatedAt:    this.updatedAtColumn(ctx, i),
			Description:  this.descriptionColumn(ctx, i),
			Name:         this.nameColumn(ctx, i),
			StartDate:    this.startDateColumn(ctx, i),
			GardenId:     this.gardenIdColumn(ctx, i),
			PlantationId: this.plantationIdColumn(ctx, i),
		}
		this.GardenTaskHandler.MustCreate(ctx, entity, nil)
	}
}
func (this *GardenTaskSeeder) createdAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *GardenTaskSeeder) updatedAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *GardenTaskSeeder) descriptionColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainLoremIpsumTextValue()
}
func (this *GardenTaskSeeder) nameColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainStringValue(i, "Garden Task Name ")
}
func (this *GardenTaskSeeder) startDateColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *GardenTaskSeeder) gardenIdColumn(ctx context.Context, i int) string {
	return strconv.Itoa(i + 1)
}
func (this *GardenTaskSeeder) plantationIdColumn(ctx context.Context, i int) string {
	return strconv.Itoa(i + 1)
}
