package seeders

// |@@| C

import (
	"context"
	"gardening/src/mdl"
	"gardening/src/srv/handlers"
	"gardening/sup/lib/seeder"
	"time"
)

type PlantSeeder struct {
	PlantHandler *handlers.PlantHandler
	Seeder       *seeder.Seeder
}

func (this *PlantSeeder) Seed(ctx context.Context) {
	for i := 0; i < 5; i++ {
		entity := &mdl.Plant{
			CreatedAt:      this.createdAtColumn(ctx, i),
			UpdatedAt:      this.updatedAtColumn(ctx, i),
			Data:           this.dataColumn(ctx, i),
			Description:    this.descriptionColumn(ctx, i),
			Exposition:     this.expositionColumn(ctx, i),
			Harvested:      this.harvestedColumn(ctx, i),
			Name:           this.nameColumn(ctx, i),
			Perennial:      this.perennialColumn(ctx, i),
			PlantingSchema: this.plantingSchemaColumn(ctx, i),
			Reference:      this.referenceColumn(ctx, i),
			Size:           this.sizeColumn(ctx, i),
		}
		this.PlantHandler.MustCreate(ctx, entity, nil)
	}
}
func (this *PlantSeeder) createdAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *PlantSeeder) updatedAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *PlantSeeder) dataColumn(ctx context.Context, i int) []byte {
	return this.Seeder.ObtainEmptyJson()
}
func (this *PlantSeeder) descriptionColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainLoremIpsumTextValue()
}
func (this *PlantSeeder) expositionColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainStringValue(i, "Plant Exposition ")
}
func (this *PlantSeeder) harvestedColumn(ctx context.Context, i int) float64 {
	return this.Seeder.ObtainDecimalValue(i)
}
func (this *PlantSeeder) nameColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainStringValue(i, "Plant Name ")
}
func (this *PlantSeeder) perennialColumn(ctx context.Context, i int) bool {
	return this.Seeder.ObtainBooleanValue(i)
}
func (this *PlantSeeder) plantingSchemaColumn(ctx context.Context, i int) mdl.PlantingSchema {
	return mdl.PlantingSchema{}
}
func (this *PlantSeeder) referenceColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainStringValue(i, "Plant Reference ")
}
func (this *PlantSeeder) sizeColumn(ctx context.Context, i int) int {
	return this.Seeder.ObtainIntegerValue(i)
}
