package seeders

// |@@| C

import (
	"context"
	"gardening/src/mdl"
	"gardening/src/srv/handlers"
	"gardening/sup/lib/seeder"
	"strconv"
	"time"
)

type PlantTaskSeeder struct {
	PlantTaskHandler *handlers.PlantTaskHandler
	Seeder           *seeder.Seeder
}

func (this *PlantTaskSeeder) Seed(ctx context.Context) {
	for i := 0; i < 5; i++ {
		entity := &mdl.PlantTask{
			CreatedAt:   this.createdAtColumn(ctx, i),
			UpdatedAt:   this.updatedAtColumn(ctx, i),
			Description: this.descriptionColumn(ctx, i),
			Name:        this.nameColumn(ctx, i),
			StartDate:   this.startDateColumn(ctx, i),
			PlantId:     this.plantIdColumn(ctx, i),
		}
		this.PlantTaskHandler.MustCreate(ctx, entity, nil)
	}
}
func (this *PlantTaskSeeder) createdAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *PlantTaskSeeder) updatedAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *PlantTaskSeeder) descriptionColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainLoremIpsumTextValue()
}
func (this *PlantTaskSeeder) nameColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainStringValue(i, "Plant Task Name ")
}
func (this *PlantTaskSeeder) startDateColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *PlantTaskSeeder) plantIdColumn(ctx context.Context, i int) string {
	return strconv.Itoa(i + 1)
}
