package seeders

// |@@| C

import (
	"context"
	"gardening/src/mdl"
	"gardening/src/srv/handlers"
	"gardening/sup/lib/seeder"
	"strconv"
	"time"
)

type PlantationSeeder struct {
	PlantationHandler *handlers.PlantationHandler
	Seeder            *seeder.Seeder
}

func (this *PlantationSeeder) Seed(ctx context.Context) {
	for i := 0; i < 5; i++ {
		entity := &mdl.Plantation{
			CreatedAt: this.createdAtColumn(ctx, i),
			UpdatedAt: this.updatedAtColumn(ctx, i),
			Name:      this.nameColumn(ctx, i),
			PlantedAt: this.plantedAtColumn(ctx, i),
			PlantId:   this.plantIdColumn(ctx, i),
			GardenId:  this.gardenIdColumn(ctx, i),
		}
		this.PlantationHandler.MustCreate(ctx, entity, nil)
	}
}
func (this *PlantationSeeder) createdAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *PlantationSeeder) updatedAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *PlantationSeeder) nameColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainStringValue(i, "Plantation Name ")
}
func (this *PlantationSeeder) plantedAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *PlantationSeeder) plantIdColumn(ctx context.Context, i int) string {
	return strconv.Itoa(i + 1)
}
func (this *PlantationSeeder) gardenIdColumn(ctx context.Context, i int) string {
	return strconv.Itoa(i + 1)
}
