package seeders

// |@@| C

import (
	"context"
	"gardening/src/mdl"
	"gardening/src/srv/handlers"
	"gardening/sup/lib/seeder"
	"strconv"
	"time"
)

type SeedProgramSeeder struct {
	SeedProgramHandler *handlers.SeedProgramHandler
	Seeder             *seeder.Seeder
}

func (this *SeedProgramSeeder) Seed(ctx context.Context) {
	for i := 0; i < 5; i++ {
		entity := &mdl.SeedProgram{
			CreatedAt:   this.createdAtColumn(ctx, i),
			UpdatedAt:   this.updatedAtColumn(ctx, i),
			Contact:     this.contactColumn(ctx, i),
			Description: this.descriptionColumn(ctx, i),
			Name:        this.nameColumn(ctx, i),
			PlantId:     this.plantIdColumn(ctx, i),
		}
		this.SeedProgramHandler.MustCreate(ctx, entity, nil)
	}
}
func (this *SeedProgramSeeder) createdAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *SeedProgramSeeder) updatedAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *SeedProgramSeeder) contactColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainStringValue(i, "Seed Program Contact ")
}
func (this *SeedProgramSeeder) descriptionColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainLoremIpsumTextValue()
}
func (this *SeedProgramSeeder) nameColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainStringValue(i, "Seed Program Name ")
}
func (this *SeedProgramSeeder) plantIdColumn(ctx context.Context, i int) string {
	return strconv.Itoa(i + 1)
}
