package seeders

// |@@| C

import (
	"context"
	"gardening/src/mdl"
	"gardening/src/srv/handlers"
	"gardening/sup/lib/seeder"
	"time"
)

type UserSeeder struct {
	Seeder      *seeder.Seeder
	UserHandler *handlers.UserHandler
}

func (this *UserSeeder) Seed(ctx context.Context) {
	for i := 0; i < 5; i++ {
		entity := &mdl.User{
			CreatedAt: this.createdAtColumn(ctx, i),
			UpdatedAt: this.updatedAtColumn(ctx, i),
			Name:      this.nameColumn(ctx, i),
		}
		this.UserHandler.MustCreate(ctx, entity, nil)
	}
}
func (this *UserSeeder) createdAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *UserSeeder) updatedAtColumn(ctx context.Context, i int) time.Time {
	return this.Seeder.ObtainTimeValue(i)
}
func (this *UserSeeder) nameColumn(ctx context.Context, i int) string {
	return this.Seeder.ObtainStringValue(i, "User Name ")
}
