package maes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/mae"
	"gardening/sup/helpers"
	"gardening/sup/lib/asserter"
	"gardening/sup/lib/storyteller"
	"gardening/sup/srv/staters"
	"testing"
)

func TestListGardenTasksMae(testing *testing.T) {
	this := &ListGardenTasksMaeTest{}
	ctx := helpers.SetupTest(this, testing)
	this.Storyteller.SetAutoScenario(ctx)

	this.Storyteller.Given("the default grow stage context")
	this.GrownStater.GoToDefaultStage(ctx)
	this.Storyteller.Given("the standard input")
	in := this.newInStructure()
	this.Storyteller.When("listing entities")
	_, err := this.ListGardenTasksMae.Act(ctx, in)
	this.Storyteller.Then("no error should occur")
	this.Asserter.WithoutError(ctx, err)
}

type ListGardenTasksMaeTest struct {
	Storyteller        *storyteller.Storyteller
	GrownStater        *staters.GrownStater
	Asserter           *asserter.Asserter
	ListGardenTasksMae *mae.ListGardenTasksMae
}

func (this *ListGardenTasksMaeTest) newInStructure() *maes.ListGardenTasksMaeIn {
	return &maes.ListGardenTasksMaeIn{}
}
