package maes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/mae"
	"gardening/sup/helpers"
	"gardening/sup/lib/asserter"
	"gardening/sup/lib/storyteller"
	"gardening/sup/srv/staters"
	"testing"
)

func TestListGardensMae(testing *testing.T) {
	this := &ListGardensMaeTest{}
	ctx := helpers.SetupTest(this, testing)
	this.Storyteller.SetAutoScenario(ctx)

	this.Storyteller.Given("the default grow stage context")
	this.GrownStater.GoToDefaultStage(ctx)
	this.Storyteller.Given("the standard input")
	in := this.newInStructure()
	this.Storyteller.When("listing entities")
	_, err := this.ListGardensMae.Act(ctx, in)
	this.Storyteller.Then("no error should occur")
	this.Asserter.WithoutError(ctx, err)
}

type ListGardensMaeTest struct {
	Storyteller    *storyteller.Storyteller
	GrownStater    *staters.GrownStater
	Asserter       *asserter.Asserter
	ListGardensMae *mae.ListGardensMae
}

func (this *ListGardensMaeTest) newInStructure() *maes.ListGardensMaeIn {
	return &maes.ListGardensMaeIn{}
}
