package maes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/mae"
	"gardening/sup/helpers"
	"gardening/sup/lib/asserter"
	"gardening/sup/lib/storyteller"
	"gardening/sup/srv/staters"
	"testing"
)

func TestListPlantsMae(testing *testing.T) {
	this := &ListPlantsMaeTest{}
	ctx := helpers.SetupTest(this, testing)
	this.Storyteller.SetAutoScenario(ctx)

	this.Storyteller.Given("the default grow stage context")
	this.GrownStater.GoToDefaultStage(ctx)
	this.Storyteller.Given("the standard input")
	in := this.newInStructure()
	this.Storyteller.When("listing entities")
	_, err := this.ListPlantsMae.Act(ctx, in)
	this.Storyteller.Then("no error should occur")
	this.Asserter.WithoutError(ctx, err)
}

type ListPlantsMaeTest struct {
	Storyteller   *storyteller.Storyteller
	GrownStater   *staters.GrownStater
	Asserter      *asserter.Asserter
	ListPlantsMae *mae.ListPlantsMae
}

func (this *ListPlantsMaeTest) newInStructure() *maes.ListPlantsMaeIn {
	return &maes.ListPlantsMaeIn{}
}
