package maes

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/mae"
	"gardening/sup/helpers"
	"gardening/sup/lib/asserter"
	"gardening/sup/lib/storyteller"
	"gardening/sup/srv/staters"
	"testing"
)

func TestListUsersMae(testing *testing.T) {
	this := &ListUsersMaeTest{}
	ctx := helpers.SetupTest(this, testing)
	this.Storyteller.SetAutoScenario(ctx)

	this.Storyteller.Given("the default grow stage context")
	this.GrownStater.GoToDefaultStage(ctx)
	this.Storyteller.Given("the standard input")
	in := this.newInStructure()
	this.Storyteller.When("listing entities")
	_, err := this.ListUsersMae.Act(ctx, in)
	this.Storyteller.Then("no error should occur")
	this.Asserter.WithoutError(ctx, err)
}

type ListUsersMaeTest struct {
	Storyteller  *storyteller.Storyteller
	GrownStater  *staters.GrownStater
	Asserter     *asserter.Asserter
	ListUsersMae *mae.ListUsersMae
}

func (this *ListUsersMaeTest) newInStructure() *maes.ListUsersMaeIn {
	return &maes.ListUsersMaeIn{}
}
