package views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/mae"
	"gardening/src/srv/html_views"
	"gardening/sup/helpers"
	"gardening/sup/lib/asserter"
	sup "gardening/sup/lib/booker"
	"gardening/sup/lib/storyteller"
	"gardening/sup/srv/staters"
	"testing"
)

func TestListGardenTasksView(testing *testing.T) {
	this := &ListGardenTasksViewTest{}
	ctx := helpers.SetupTest(this, testing)
	this.Storyteller.SetAutoScenario(ctx)

	this.Storyteller.As("User")
	this.Storyteller.Given("the default grow stage context")
	this.GrownStater.GoToDefaultStage(ctx)
	this.Storyteller.Given("the standard input")
	in := this.newInStructure()
	this.Storyteller.Given("an acted maestro")
	out, err := this.ListGardenTasksMae.Act(ctx, in)
	this.Storyteller.When("viewing")
	h := this.ListGardenTasksView.H(out)
	this.Storyteller.Then("no error should occur")
	this.Asserter.WithoutError(ctx, err)
	this.Storyteller.Also("add doc page")
	this.Booker.AddPage("ListGardenTasksView", h)
}

type ListGardenTasksViewTest struct {
	Storyteller         *storyteller.Storyteller
	GrownStater         *staters.GrownStater
	Asserter            *asserter.Asserter
	ListGardenTasksMae  *mae.ListGardenTasksMae
	ListGardenTasksView *html_views.ListGardenTasksView
	Booker              *sup.Booker
}

func (this *ListGardenTasksViewTest) newInStructure() *maes.ListGardenTasksMaeIn {
	return &maes.ListGardenTasksMaeIn{}
}
