package views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/mae"
	"gardening/src/srv/html_views"
	"gardening/sup/helpers"
	"gardening/sup/lib/asserter"
	sup "gardening/sup/lib/booker"
	"gardening/sup/lib/storyteller"
	"gardening/sup/srv/staters"
	"testing"
)

func TestListGardensView(testing *testing.T) {
	this := &ListGardensViewTest{}
	ctx := helpers.SetupTest(this, testing)
	this.Storyteller.SetAutoScenario(ctx)

	this.Storyteller.As("User")
	this.Storyteller.Given("the default grow stage context")
	this.GrownStater.GoToDefaultStage(ctx)
	this.Storyteller.Given("the standard input")
	in := this.newInStructure()
	this.Storyteller.Given("an acted maestro")
	out, err := this.ListGardensMae.Act(ctx, in)
	this.Storyteller.When("viewing")
	h := this.ListGardensView.H(out)
	this.Storyteller.Then("no error should occur")
	this.Asserter.WithoutError(ctx, err)
	this.Storyteller.Also("add doc page")
	this.Booker.AddPage("ListGardensView", h)
}

type ListGardensViewTest struct {
	Storyteller     *storyteller.Storyteller
	GrownStater     *staters.GrownStater
	Asserter        *asserter.Asserter
	ListGardensMae  *mae.ListGardensMae
	ListGardensView *html_views.ListGardensView
	Booker          *sup.Booker
}

func (this *ListGardensViewTest) newInStructure() *maes.ListGardensMaeIn {
	return &maes.ListGardensMaeIn{}
}
