package views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/mae"
	"gardening/src/srv/html_views"
	"gardening/sup/helpers"
	"gardening/sup/lib/asserter"
	sup "gardening/sup/lib/booker"
	"gardening/sup/lib/storyteller"
	"gardening/sup/srv/staters"
	"testing"
)

func TestListPlantTasksView(testing *testing.T) {
	this := &ListPlantTasksViewTest{}
	ctx := helpers.SetupTest(this, testing)
	this.Storyteller.SetAutoScenario(ctx)

	this.Storyteller.As("User")
	this.Storyteller.Given("the default grow stage context")
	this.GrownStater.GoToDefaultStage(ctx)
	this.Storyteller.Given("the standard input")
	in := this.newInStructure()
	this.Storyteller.Given("an acted maestro")
	out, err := this.ListPlantTasksMae.Act(ctx, in)
	this.Storyteller.When("viewing")
	h := this.ListPlantTasksView.H(out)
	this.Storyteller.Then("no error should occur")
	this.Asserter.WithoutError(ctx, err)
	this.Storyteller.Also("add doc page")
	this.Booker.AddPage("ListPlantTasksView", h)
}

type ListPlantTasksViewTest struct {
	Storyteller        *storyteller.Storyteller
	GrownStater        *staters.GrownStater
	Asserter           *asserter.Asserter
	ListPlantTasksMae  *mae.ListPlantTasksMae
	ListPlantTasksView *html_views.ListPlantTasksView
	Booker             *sup.Booker
}

func (this *ListPlantTasksViewTest) newInStructure() *maes.ListPlantTasksMaeIn {
	return &maes.ListPlantTasksMaeIn{}
}
