package views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/mae"
	"gardening/src/srv/html_views"
	"gardening/sup/helpers"
	"gardening/sup/lib/asserter"
	sup "gardening/sup/lib/booker"
	"gardening/sup/lib/storyteller"
	"gardening/sup/srv/staters"
	"testing"
)

func TestListSeedProgramsView(testing *testing.T) {
	this := &ListSeedProgramsViewTest{}
	ctx := helpers.SetupTest(this, testing)
	this.Storyteller.SetAutoScenario(ctx)

	this.Storyteller.As("User")
	this.Storyteller.Given("the default grow stage context")
	this.GrownStater.GoToDefaultStage(ctx)
	this.Storyteller.Given("the standard input")
	in := this.newInStructure()
	this.Storyteller.Given("an acted maestro")
	out, err := this.ListSeedProgramsMae.Act(ctx, in)
	this.Storyteller.When("viewing")
	h := this.ListSeedProgramsView.H(out)
	this.Storyteller.Then("no error should occur")
	this.Asserter.WithoutError(ctx, err)
	this.Storyteller.Also("add doc page")
	this.Booker.AddPage("ListSeedProgramsView", h)
}

type ListSeedProgramsViewTest struct {
	Storyteller          *storyteller.Storyteller
	GrownStater          *staters.GrownStater
	Asserter             *asserter.Asserter
	ListSeedProgramsMae  *mae.ListSeedProgramsMae
	ListSeedProgramsView *html_views.ListSeedProgramsView
	Booker               *sup.Booker
}

func (this *ListSeedProgramsViewTest) newInStructure() *maes.ListSeedProgramsMaeIn {
	return &maes.ListSeedProgramsMaeIn{}
}
