package views

// |@@| C

import (
	"gardening/src/dat/maes"
	"gardening/src/mae"
	"gardening/src/srv/html_views"
	"gardening/sup/helpers"
	"gardening/sup/lib/asserter"
	sup "gardening/sup/lib/booker"
	"gardening/sup/lib/storyteller"
	"gardening/sup/srv/staters"
	"testing"
)

func TestListUsersView(testing *testing.T) {
	this := &ListUsersViewTest{}
	ctx := helpers.SetupTest(this, testing)
	this.Storyteller.SetAutoScenario(ctx)

	this.Storyteller.As("User")
	this.Storyteller.Given("the default grow stage context")
	this.GrownStater.GoToDefaultStage(ctx)
	this.Storyteller.Given("the standard input")
	in := this.newInStructure()
	this.Storyteller.Given("an acted maestro")
	out, err := this.ListUsersMae.Act(ctx, in)
	this.Storyteller.When("viewing")
	h := this.ListUsersView.H(out)
	this.Storyteller.Then("no error should occur")
	this.Asserter.WithoutError(ctx, err)
	this.Storyteller.Also("add doc page")
	this.Booker.AddPage("ListUsersView", h)
}

type ListUsersViewTest struct {
	Storyteller   *storyteller.Storyteller
	GrownStater   *staters.GrownStater
	Asserter      *asserter.Asserter
	ListUsersMae  *mae.ListUsersMae
	ListUsersView *html_views.ListUsersView
	Booker        *sup.Booker
}

func (this *ListUsersViewTest) newInStructure() *maes.ListUsersMaeIn {
	return &maes.ListUsersMaeIn{}
}
