package main

import (
	"gardening/sup/helpers"
	"os"
)

func main() {
	if len(os.Args) < 2 {
		println("Args: db:reset or db:seed")
		return
	}

	route := os.Args[1]

	ctx, canister, _ := helpers.NewDefaultCanisterScene()

	if route == "go-dev-stage" {
		println("Moving DB to dev stage")
		canister.DevStater.GoToStage(ctx)
		println("Db moved to dev stage")
		return
	}
	if route == "go-prod-stage" {
		println("Moving DB to prod stage")
		canister.ProdStater.GoToStage(ctx)
		println("Db moved to prod stage")
		return
	}
	println("Unknown route")
}
