package fedcm

import (
	"fmt"
	"strings"
)

// Code generated by cdproto-gen. DO NOT EDIT.

// LoginState whether this is a sign-up or sign-in action for this account,
// i.e. whether this account has ever been used to sign in to this RP before.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/FedCm#type-LoginState
type LoginState string

// String returns the LoginState as string value.
func (t LoginState) String() string {
	return string(t)
}

// LoginState values.
const (
	LoginStateSignIn LoginState = "SignIn"
	LoginStateSignUp LoginState = "SignUp"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *LoginState) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch LoginState(s) {
	case LoginStateSignIn:
		*t = LoginStateSignIn
	case LoginStateSignUp:
		*t = LoginStateSignUp
	default:
		return fmt.Errorf("unknown LoginState value: %v", s)
	}
	return nil
}

// DialogType the types of FedCM dialogs.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/FedCm#type-DialogType
type DialogType string

// String returns the DialogType as string value.
func (t DialogType) String() string {
	return string(t)
}

// DialogType values.
const (
	DialogTypeAccountChooser  DialogType = "AccountChooser"
	DialogTypeAutoReauthn     DialogType = "AutoReauthn"
	DialogTypeConfirmIdpLogin DialogType = "ConfirmIdpLogin"
	DialogTypeError           DialogType = "Error"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *DialogType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch DialogType(s) {
	case DialogTypeAccountChooser:
		*t = DialogTypeAccountChooser
	case DialogTypeAutoReauthn:
		*t = DialogTypeAutoReauthn
	case DialogTypeConfirmIdpLogin:
		*t = DialogTypeConfirmIdpLogin
	case DialogTypeError:
		*t = DialogTypeError
	default:
		return fmt.Errorf("unknown DialogType value: %v", s)
	}
	return nil
}

// DialogButton the buttons on the FedCM dialog.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/FedCm#type-DialogButton
type DialogButton string

// String returns the DialogButton as string value.
func (t DialogButton) String() string {
	return string(t)
}

// DialogButton values.
const (
	DialogButtonConfirmIdpLoginContinue DialogButton = "ConfirmIdpLoginContinue"
	DialogButtonErrorGotIt              DialogButton = "ErrorGotIt"
	DialogButtonErrorMoreDetails        DialogButton = "ErrorMoreDetails"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *DialogButton) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch DialogButton(s) {
	case DialogButtonConfirmIdpLoginContinue:
		*t = DialogButtonConfirmIdpLoginContinue
	case DialogButtonErrorGotIt:
		*t = DialogButtonErrorGotIt
	case DialogButtonErrorMoreDetails:
		*t = DialogButtonErrorMoreDetails
	default:
		return fmt.Errorf("unknown DialogButton value: %v", s)
	}
	return nil
}

// AccountURLType the URLs that each account has.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/FedCm#type-AccountUrlType
type AccountURLType string

// String returns the AccountURLType as string value.
func (t AccountURLType) String() string {
	return string(t)
}

// AccountURLType values.
const (
	AccountURLTypeTermsOfService AccountURLType = "TermsOfService"
	AccountURLTypePrivacyPolicy  AccountURLType = "PrivacyPolicy"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AccountURLType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AccountURLType(s) {
	case AccountURLTypeTermsOfService:
		*t = AccountURLTypeTermsOfService
	case AccountURLTypePrivacyPolicy:
		*t = AccountURLTypePrivacyPolicy
	default:
		return fmt.Errorf("unknown AccountURLType value: %v", s)
	}
	return nil
}

// Account corresponds to IdentityRequestAccount.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/FedCm#type-Account
type Account struct {
	AccountID         string     `json:"accountId"`
	Email             string     `json:"email"`
	Name              string     `json:"name"`
	GivenName         string     `json:"givenName"`
	PictureURL        string     `json:"pictureUrl"`
	IdpConfigURL      string     `json:"idpConfigUrl"`
	IdpLoginURL       string     `json:"idpLoginUrl"`
	LoginState        LoginState `json:"loginState"`
	TermsOfServiceURL string     `json:"termsOfServiceUrl,omitempty,omitzero"` // These two are only set if the loginState is signUp
	PrivacyPolicyURL  string     `json:"privacyPolicyUrl,omitempty,omitzero"`
}
